<?php

use \UtillzCore\Inc\Src\Request\Request;
use \UtillzCore\Inc\Src\Wallet;

defined('ABSPATH') || exit;

$wallet = new Wallet();
$payouts = $wallet->get_payouts();
$request = Request::instance();
$page = $request->has('onpage') ? $request->get('onpage') : 1;
$min_payout = (float) get_option( 'ulz_min_payout', 0 );

?>

<div class="ulz-boxes-action">
    <div>
        <div>
            <strong class="ulz-button ulz--mutted">
                <?php
                    echo sprintf(
                        esc_html__( 'Your current balance is: %s', 'utillz-core' ),
                        Ucore()->format_price( floor( $wallet->get_balance() * 100 ) / 100 )
                    );
                ?>
            </strong>
        </div>
        <?php if( $min_payout ): ?>
            <div>
                <?php
                    echo sprintf(
                        esc_html__( 'Minimum payout amount: %s', 'utillz-core' ),
                        Ucore()->format_price( $min_payout )
                    );
                ?>
            </div>
        <?php endif; ?>
    </div>
    <div>
        <a href="#" class="ulz-button" data-modal="payout">
            <span><?php esc_html_e( 'Request a payout', 'utillz-core' ); ?></span>
        </a>
    </div>
</div>

<?php if( $payouts->results ): ?>
    <div class="ulz-boxes">
        <?php foreach( $payouts->results as $payout ): ?>
            <div class="ulz--cell">
                <div class="ulz-box">
                    <div class="ulz--heading">
                        <div class="ulz--title">
                            <h4><?php echo Ucore()->format_price( $payout->amount ); ?></h4>
                        </div>
                    </div>
                    <div class="ulz--status">
                        <div class="ulz-post-status ulz-status-<?php echo $payout->status; ?>">
                            <span>
                                <?php
                                    switch( $payout->status ) {
                                        case 'pending': esc_html_e( 'Pending', 'utillz-core' ); break;
                                        case 'approved': esc_html_e( 'Approved', 'utillz-core' ); break;
                                        case 'declined': esc_html_e( 'Declined', 'utillz-core' ); break;
                                    }
                                ?>
                            </span>
                        </div>
                    </div>
                    <div class="ulz--content">
                        <table>
                            <tbody>
                                <tr>
                                    <td><?php esc_html_e( 'Type', 'utillz-core' ); ?></td>
                                    <td>
                                        <?php
                                            switch( $payout->payment_method ) {
                                                case 'paypal': esc_html_e( 'PayPal', 'utillz-core' ); break;
                                                case 'bank_transfer': esc_html_e( 'Direct Bank Transfer', 'utillz-core' ); break;
                                            }
                                        ?>
                                    </td>
                                </tr>
                                <tr>
                                    <td><?php esc_html_e( 'Request date', 'utillz-core' ); ?></td>
                                    <td><?php echo date_i18n( get_option('date_format'), strtotime( $payout->created_at ) ); ?></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <?php if( $payout->status == 'pending' ): ?>
                        <div class="ulz--actions">
                            <div class="ulz--primary-actions">
                                <ul>
                                    <li>
                                        <?php
                                            $action_url = add_query_arg([
                                                'action' => 'cancel_payout',
                                                'id' => $payout->id
                                            ]);
                                            $action_url = wp_nonce_url( $action_url, 'utillz_account_cancel_payout' );
                                        ?>
                                        <a href="<?php echo esc_url( $action_url ); ?>" data-action="payout-cancel"><i class="fas fa-trash-alt"></i></a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

        <?php endforeach; ?>
    </div>
<?php else: ?>
    <p class="ulz-weight-700"><?php esc_html_e( 'No payouts were found', 'utillz-core' ); ?></p>
<?php endif; ?>

<div class="ulz-paging">
    <?php

        echo Ucore()->pagination([
            'base' => add_query_arg( [ 'onpage' => '%#%' ], wc_get_account_endpoint_url( 'payouts' ) ),
            'format' => '?onpage=%#%',
            'current' => $page,
            'total' => $payouts->max_num_pages,
        ]);

    ?>
</div>

<?php Ucore()->the_template('modals/payouts/content'); ?>
